import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class AllowedFileTypesSection extends StatefulWidget {
  const AllowedFileTypesSection({Key? key}) : super(key: key);

  @override
  _AllowedFileTypesSectionState createState() => _AllowedFileTypesSectionState();
}

class _AllowedFileTypesSectionState extends State<AllowedFileTypesSection> with AppActiveContentMixin {
  @override
  build(context) {
    return FormEditorPage(
      heading: 'Allowed File Types',
      items: [
        SettingItem(
          intId: AppSettings.ID_SETTING_SUPPORTED_USER_DISPLAY_IMAGE_FILE_FORMAT,
          settingKey: AppSettings.KEY_SETTING_SUPPORTED_USER_DISPLAY_IMAGE_FILE_FORMAT,
          type: FieldType.text,
          leading: 'Allowed extensions for User Display Image',
          placeholder: 'e.g jpg, png, webp',
          description: "Comma separater list of extensions that users can upload for display images. (in CSV format)",
        ),
        SettingItem(
          intId: AppSettings.ID_SETTING_SUPPORTED_POST_DISPLAY_CONTENT_ITEM_FILE_FORMAT,
          settingKey: AppSettings.KEY_SETTING_SUPPORTED_POST_DISPLAY_CONTENT_ITEM_FILE_FORMAT,
          type: FieldType.text,
          leading: 'Allowed extensions for Post Display Image',
          placeholder: 'e.g jpg, png, webp',
          description: "Comma separater list of extensions that users can upload for post images. (in CSV format)",
        ),
      ],
    );
  }
}
